//	Pro_Utils.h

#ifndef _H_Pro_Utils
#define _H_Pro_Utils

#include "ProStructs.h"

short		Pro_GetNameLength(Pro_TypeName *typeName);
char	 	*Pro_GetEntryName(Pro_TypeName *typeName, ushort locaseBits, char *buf);
char		*Pro_GetDirName(Pro_DirHeader *dirHeader, char *buf);
char		*Pro_GetFileName(Pro_DirEntry *dirEntry, char *buf);

void	 	Pro_SetEntryName(Pro_TypeName *typeName, ushort *locaseBits, char *buf);
void		Pro_SetDirName(Pro_DirHeader *dirHeader, char *buf);
void		Pro_SetFileName(Pro_DirEntry *dirEntry, char *buf);

DateTimeRec		*Pro_GetDateTime(Pro_DateTime *pro_dtP, DateTimeRec *mac_dtP);
void			Pro_GetDateStamps(
	Pro_DirEntry	*dirEntry, 
	DateTimeRec		*creDate, 
	DateTimeRec		*modDate);
	
void			Pro_SetDateTime(DateTimeRec *mac_dtP, Pro_DateTime *pro_dtP);
void			Pro_SetDateStamps(
	Pro_DirEntry	*dirEntry, 
	DateTimeRec		*creDate, 
	DateTimeRec		*modDate);

Pro_BlockNum	Pro_GetBlocksUsed(Pro_DirEntry *entryP);

Pro_BlockNum	Pro_GetIndexBlockShort(Pro_IndexBlock *block, Pro_BlockNum index);
void			Pro_SetIndexBlockShort(Pro_IndexBlock *block, ushort index, Pro_BlockNum value);

OSErr		Pro_DeleteEntry(DiskImageRec *imageRecP, Pro_DirEntry *entryP);

OSErr		Pro_WriteBlock(DiskImageRec *imageRecP, Pro_DirEntry *entryP, ushort numBytesS, Pro_Block *block);

void		Mac_To_Pro_FileType(OSType macType, Byte *a2TypeP, ushort *a2AuxTypeP);
void		Pro_To_Mac_FileType(
	Byte	proType, 
	ushort	proAuxType, 
	OSType	*fileType, 
	OSType	*fileCreator);

#endif

